namespace Microsoft.Samples.PlanMyNight.AddIns.PrintItinerary.Tests
{
    using System.Collections.Generic;
    using System.ComponentModel.Composition.Hosting;
    using System.Linq;
    using System.Web.Mvc;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight;
    using Microsoft.Samples.PlanMyNight.AddIns.PrintItinerary;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class ItineraryContextualActionsExportFixture
    {
        [TestMethod]
        public void ShouldExportMefConsumableRouteForRendering()
        {
            var catalog = new TypeCatalog(typeof(ItineraryContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<ExtensionLink>();

            Assert.AreEqual(1, actual.Count());
        }

        [TestMethod]
        public void ShouldExportMefConsumableMetadataForItineraryExtensionSite()
        {
            var catalog = new TypeCatalog(typeof(ItineraryContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<ExtensionLink, IExtensionSiteMetadata>();

            Assert.AreEqual(1, actual.Count());
            var export = actual.ElementAt(0);
            Assert.AreEqual("ItineraryLinks", export.Metadata.TargetExtensionSite);
            Assert.AreEqual("Print", export.Value.LinkText);
        }
    }
}
